//
//  MCUserDefaults.h
//  MCFoundation
//
//  Created by Michael Clark on 10/04/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPDatabaseConnection;

@interface MCUserDefaults : NSObject {
	
	MCPDatabaseConnection*  _dbConnection;
	NSNumber*               _hostID;
	
	NSMutableDictionary*    _configRegistry;
	NSMutableDictionary*    _valueRegistry;
	
	BOOL                    _cacheHostValues;
	  // Set to NO to prevent host values from being cached, it is YES by default
	
}
// Only to be used for database independent purposes!
+ (MCUserDefaults *)sharedUserDefaults;


// Allow the column names to be altered for certain database engines
+ (void)setHostIDKey: (NSString*)aKey;
+ (void)setKeyKey: (NSString*)aKey;
+ (void)setLastTypeKey: (NSString*)aKey;
+ (void)setValueKey: (NSString*)aKey;
+ (void)setBlobValueKey: (NSString*)aKey;



- (id)initWithDatabaseConnection: (MCPDatabaseConnection*)connection;
- (id)initWithDatabaseConnection: (MCPDatabaseConnection*)connection forDefaultsHostID: (NSNumber*)anID;

- (void)replaceDatabaseConnectionWith: (MCPDatabaseConnection*)connection;

- (void)registerUserDefaultsAtPath: (NSString*)aPath;
- (NSDictionary*)userDefaultsConfig;
- (void)setUserDefaultsConfig: (NSDictionary*)aDictionary;

- (void)flushDefaultsCache;

// The following 3 methods strictly use the default configuration to determine information like storage and scope
- (id)objectForKey: (NSString*)aKey;
- (void)setObject: (id)object forKey: (NSString*)aKey;
- (void)removeObjectForKey: (NSString*)aKey;

- (BOOL)hostValueExistsForKey: (NSString*)aKey;

// The following 3 methods allow you to take advantage of advanced features:
// You can specify a different hostID to read/write the value for a different host
// You can speficy no hostID which will read/write a database scoped value which can be used with fallback defaults
//  (i.e. you can specify a defalt to be fallback, meaning that if there is no host level value, a database level value will be looked for)
- (id)objectForKey: (NSString*)aKey hostID: (NSNumber*)aHostID;
- (void)setObject: (id)object forKey: (NSString*)aKey hostID: (NSNumber*)aHostID;
- (void)removeObjectForKey: (NSString*)aKey hostID: (NSNumber*)aHostID;

- (NSString*)stringForKey: (NSString*)aKey;
- (void)setString: (NSString*)aString forKey: (NSString*)aKey;

- (NSArray*)arrayForKey: (NSString*)aKey;
- (void)setArray: (NSArray*)anArray forKey: (NSString*)aKey;
- (NSMutableArray*)mutableArrayForKey: (NSString*)aKey;

- (NSDictionary*)dictionaryForKey: (NSString*)aKey;
- (void)setDictionary: (NSDictionary*)aDictionary forKey: (NSString*)aKey;
- (NSMutableDictionary*)mutableDictionaryForKey: (NSString*)aKey;

// This will use the blob mechanism for db storage
- (NSData*)dataForKey: (NSString*)aKey;
- (void)setData: (NSData*)aData forKey: (NSString*)aKey;
- (NSMutableData*)mutableDataForKey: (NSString*)aKey;

- (BOOL)boolForKey: (NSString*)aKey;
- (void)setBool: (BOOL)flag forKey: (NSString*)aKey;

- (float)floatForKey: (NSString*)aKey;
- (void)setFloat: (float)aFloat forKey: (NSString*)aKey;

- (double)doubleForKey: (NSString*)aKey;
- (void)setDouble: (double)aDouble forKey: (NSString*)aKey;

- (int)intForKey: (NSString*)aKey;
- (void)setInt: (int)anInt forKey: (NSString*)aKey;

- (NSCalendarDate *)calendarDateForKey: (NSString*)aKey;
- (void)setCalendarDate: (NSCalendarDate *)aCalendarDate forKey: (NSString*)aKey;

- (id)defaultValueForKey: (NSString*)aKey;

- (NSMutableDictionary *)configRegistry;
- (NSMutableDictionary *)valueRegistry;

- (void)setHostID:(NSNumber *)anID;
- (NSNumber *)hostID;

- (BOOL)cacheHostValues;
- (void)setCacheHostValues: (BOOL)flag;

@end
